	% DExample 15.7
	clear all, close all, clc
	wcT = 0.7*pi;	 wsT = 0.77*pi; 	dc = 0.01; 	ds = 0.001; % Highpass
	wcTK = 0.23*pi;	 wsTK = 0.3*pi; 	dcHP = ds; 	dsHP = dc; % Kernel filter
	wT = linspace(0, pi, 1000);
	M = 2;
	[NK, Be, D, W] = L_PHASE_LP_FIR_ORDER(M*[wcTK wsTK], [ds dc/1.3]);
	NK
	[hK, Err] = REMEZ_FIR(NK, Be, D, W, 'm');	
	HK = freqz(hK,1,M*wT);
	subplot(3,1,1), PLOT_MAG_Z_dB(wT, HK, pi, 90, 'H_K')
	Norder = 18;	wcTK = 0.25*pi;
	[hD, Err] = L_PHASE_LP_HB_FIR(Norder, pi-wcTK);
	n = 0:length(hD)-1; 	
	hD = hD.*(-1).^n;	% Frequency transformation z -> -z
	HD = freqz(hD,1,wT); 
	hold on
	PLOT_MAG_Z_dB(wT, HD, pi, 90, 'H_D')	
	hI = hD; 			% Interpolation filter  
	HI = HD; 		
	HHP = HI.*HK.*HD;
	subplot(3,1,2), PLOT_MAG_Z_dB(wT, HHP, pi, 90, 'H_HP')
	hDK = conv(down_sample(hD,2), hK); 
	hHP = conv(up_sample(hDK,2), M*hI);	% Scale with M
	Delayh = zeros(size(1:length(hHP))); 
	D = ceil((length(Delayh))/2)	
	Delayh(D) = 1; 		% Delay sequence 
	hLP = Delayh-hHP; 	% Wideband multirate lowpass filter 
	HLP = freqz(hLP,1,wT); 
	subplot(3,1,3), PLOT_MAG_Z_dB(wT, HLP, pi, 90, 'H_LP')
	Amax = max(H_2_MAG(HLP(1:701)))-min(H_2_MAG(HLP(1:701)))
	Amin = -max(H_2_MAG(HLP(771:end)))
	zoom on
		xlabel('{\it\omegaT} [rad]');	
